# Interview Title Overlay - SPX Template for LTN Schedule

## Overview
This is a professional interview title overlay template for LTN Schedule that displays a person's name and title/position with smooth animations. The overlay slides in from the bottom of the screen with an elegant cubic-bezier animation and slides out when stopped.

## Features
- **Smooth Animations**: Cubic-bezier easing for natural slide-in and slide-out effects
- **Professional Design**: Dark gradient background with accent color highlighting
- **Customizable Colors**: Operators can customize name color, accent/title color, and background color
- **Responsive Design**: Adapts to different screen resolutions
- **Accent Line Animation**: Animated underline that grows in with the text
- **Text Shadow**: Professional text shadowing for better visibility on video backgrounds

## Template Fields (Editable in LTN Schedule)

| Field | Type | Description | Default Value |
|-------|------|-------------|----------------|
| Person Name | Text | The name of the interview person | John Anderson |
| Title/Position | Text | The person's title or position | Chief Executive Officer |
| Name Text Color | Color | Color of the person's name | White (255, 255, 255) |
| Accent/Title Color | Color | Color of the title text and accent line | Crimson Red (220, 20, 60) |
| Background Color | Color | Color of the background panel | Dark Gray (30, 30, 30) |

## File Structure
```
Title for Documentation/
├── index.html                 # Main template file
├── js/
│   └── spx_interface.js       # SPX communication library
└── README.md                  # This file
```

## Animation Timing
- **Slide-In Duration**: 0.6 seconds
- **Accent Line Animation**: Starts at 0.2s, completes with text (0.8s total)
- **Slide-Out Duration**: 0.5 seconds
- **Easing**: cubic-bezier(0.34, 1.56, 0.64, 1) for in-animation
- **Easing**: cubic-bezier(0.34, 0.69, 0.58, 0.87) for out-animation

## Animation Behavior
1. **Play/In**: When the operator clicks PLAY in LTN Schedule:
   - Title bar slides up from the bottom with elasticity
   - Accent line draws in from left to right
   - Text and background fade in together

2. **Stop/Out**: When the operator clicks STOP in LTN Schedule:
   - Title bar slides down off-screen
   - Element becomes invisible after animation

## Usage in LTN Schedule
1. Export this folder as a ZIP file
2. Upload to LTN Schedule via Graphics > Upload Templates
3. Create a new graphic event and select "Interview Title Overlay"
4. Edit the fields:
   - Enter the person's name
   - Enter their title/position
   - Adjust colors as needed for your broadcast
5. Click PLAY to display the overlay with animation
6. Click STOP to hide the overlay with animation

## Customization Tips

### Adjusting Animation Speed
Open `index.html` and modify the transition durations in the CSS:
```css
#titleBar {
    transition: all 0.6s cubic-bezier(0.34, 1.56, 0.64, 1);
}
```
Change `0.6s` to a faster value (e.g., `0.4s`) or slower (e.g., `0.8s`)

### Changing Default Colors
Modify the color values in the CSS `:root` variables:
```css
:root {
    --primary-color: rgba(255, 255, 255, 1);     /* Name text color */
    --accent-color: rgba(220, 20, 60, 1);        /* Title/accent color */
}
```

### Positioning
Adjust the position by modifying:
```css
#titleBar {
    margin-left: 40px;        /* Distance from left edge */
    margin-bottom: 40px;      /* Distance from bottom edge */
}
```

### Width
Change the maximum width of the title bar:
```css
#titleBar {
    max-width: 800px;    /* Change this value */
}
```

## Technical Details

### SPX Template Definition
The template includes a `SPXGCTemplateDefinition` object that tells LTN Schedule:
- **Description**: Human-readable name in the UI
- **Output Layer**: Set to layer 10 (overlay layer)
- **Play Mode**: Manual (operator controls play/stop)
- **Data Fields**: Defines which text inputs operators see

### Data Flow
1. Operator enters data in LTN Schedule UI
2. Data is stored in hidden divs (e.g., `<div id="personName"></div>`)
3. `runTemplateUpdate()` reads from hidden divs and updates display
4. `runAnimationIN()` is called when play is triggered
5. `runAnimationOUT()` is called when stop is triggered

## Browser Compatibility
- Modern browsers with CSS3 support (Chrome, Firefox, Safari, Edge)
- CSS custom properties (CSS Variables)
- CSS transforms and transitions
- Flexbox layout

## Notes
- The template uses `will-change: transform, opacity` for better animation performance
- Text shadows are applied for visibility on bright video backgrounds
- The background uses a linear gradient for a professional appearance
- The template maintains 16:9 aspect ratio awareness with responsive font sizing

## Support
For issues or questions about LTN Schedule templates, visit:
https://ltnglobal.zendesk.com/hc/en-us/sections/43379329444755-Graphical-Overlay
